<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Files;
use common\models\Groups;
use backend\models\Admin;

/**
 * FilesSearch represents the model behind the search form about `common\models\Files`.
 */
class FilesLoaderSearch extends Files
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'size', 'admin_id', 'user_id', 'destination', 'current'], 'integer'],
            [['created_at', 'bots', 'filename', 'storedfilename', 'filetype', 'group', 'version'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $request = Yii::$app->request;
        $group_filter = $request->get('id');
        if(isset($group_filter)){
            $accessFilter = [];
            array_push($accessFilter, Groups::findOne(['id' => $group_filter]));
        }else{
            $accessFilter = json_decode(Yii::$app->user->identity->groups);
        }

        
        
        $query = Files::find()->orderBy(
            [
            new \yii\db\Expression('actual IS NULL ASC, actual desc')
            ]
        )->andFilterWhere(['group' => $accessFilter])->andFilterWhere(['>=', 'destination',10]);
        
        //$query = Files::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        //$query->andFilterWhere(['group' => $accessFilter]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'admin_id' => $this->admin_id,
            'user_id' => $this->admin_id,
            'created_at' => $this->created_at,
            'size' => $this->size,
            'destination' => $this->destination,
            'current' => $this->current,
        ]);

        $query->andFilterWhere(['like', 'bots', $this->bots])
            ->andFilterWhere(['like', 'filename', $this->filename])
            ->andFilterWhere(['like', 'storedfilename', $this->storedfilename])
            ->andFilterWhere(['like', 'group', $this->group])
            ->andFilterWhere(['like', 'version', $this->version])
            ->andFilterWhere(['like', 'filetype', $this->filetype]);

        return $dataProvider;
    }
}
